<?php

declare(strict_types=1);

namespace App\Orchid\Screens\CalificacionPeriodo;

use App\Models\CalificacionPeriodo;
use App\Orchid\Layouts\CalificacionPeriodo\CalificacionPeriodoListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class CalificacionPeriodoListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'calificacionesPeriodo' => CalificacionPeriodo::with(['alumno.user', 'asignatura', 'docente.user', 'periodo'])
                ->defaultSort('created_at', 'desc')
                ->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Promedios de Calificaciones por Período';
    }

    public function description(): ?string
    {
        return 'Lista de calificaciones por período académico personalizado.';
    }

    public function permission(): ?iterable
    {
        return null;
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.calificaciones-periodo.create'),
        ];
    }

    public function layout(): iterable
    {
        return [CalificacionPeriodoListLayout::class];
    }

    public function remove(Request $request): void
    {
        CalificacionPeriodo::where('alumno_id', $request->get('alumno_id'))
            ->where('asignatura_id', $request->get('asignatura_id'))
            ->where('docente_id', $request->get('docente_id'))
            ->where('periodo_id', $request->get('periodo_id'))
            ->delete();
        Toast::info(__('Calificación por período eliminada correctamente'));
    }
}

