<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Ciclo;

use App\Models\Ciclo;
use App\Orchid\Layouts\Ciclo\CicloListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class CicloListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'ciclos' => Ciclo::defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Ciclos';
    }

    public function description(): ?string
    {
        return 'Lista completa de todos los ciclos registrados en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.ciclos.create'),
        ];
    }

    public function layout(): iterable
    {
        return [CicloListLayout::class];
    }

    public function remove(Request $request): void
    {
        Ciclo::findOrFail($request->get('id'))->delete();
        Toast::info(__('Ciclo eliminado correctamente'));
    }
}

