<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Colegio;

use App\Models\Colegio;
use App\Orchid\Layouts\Colegio\ColegioListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class ColegioListScreen extends Screen
{
    /**
     * Fetch data to be displayed on the screen.
     *
     * @return array
     */
    public function query(): iterable
    {
        return [
            'colegios' => Colegio::defaultSort('id', 'desc')->paginate(),
        ];
    }

    /**
     * The name of the screen displayed in the header.
     */
    public function name(): ?string
    {
        return 'Gestión de Colegios';
    }

    /**
     * Display header description.
     */
    public function description(): ?string
    {
        return 'Lista completa de todos los colegios registrados en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    /**
     * The screen's action buttons.
     *
     * @return \Orchid\Screen\Action[]
     */
    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.colegios.create'),
        ];
    }

    /**
     * The screen's layout elements.
     *
     * @return \Orchid\Screen\Layout[]|string[]
     */
    public function layout(): iterable
    {
        return [
            ColegioListLayout::class,
        ];
    }

    /**
     * @param Request $request
     * @return void
     */
    public function remove(Request $request): void
    {
        Colegio::findOrFail($request->get('id'))->delete();

        Toast::info(__('Colegio eliminado correctamente'));
    }
}
