<?php

declare(strict_types=1);

namespace App\Orchid\Screens\ColegioCiclo;

use App\Models\ColegioCiclo;
use App\Orchid\Layouts\ColegioCiclo\ColegioCicloEditLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Screen;
use Orchid\Support\Color;
use Orchid\Support\Facades\Layout;
use Orchid\Support\Facades\Toast;

class ColegioCicloEditScreen extends Screen
{
    public $colegioCiclo;

    public function query(ColegioCiclo $colegioCiclo): iterable
    {
        $colegioCiclo->load(['colegio', 'ciclo']);
        return ['colegio_ciclo' => $colegioCiclo];
    }

    public function name(): ?string { return $this->colegioCiclo->exists ? 'Editar Colegio-Ciclo' : 'Crear Colegio-Ciclo'; }
    public function description(): ?string { return 'Información del colegio-ciclo.'; }
    public function permission(): ?iterable { return null; }

    public function commandBar(): iterable
    {
        return [
            Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove')->canSee($this->colegioCiclo->exists),
            Button::make(__('Guardar'))->icon('bs.check-circle')->method('save'),
        ];
    }

    public function layout(): iterable
    {
        return [
            Layout::block(ColegioCicloEditLayout::class)
                ->title(__('Información del Colegio-Ciclo'))
                ->commands(Button::make(__('Guardar'))->type(Color::BASIC)->icon('bs.check-circle')->canSee($this->colegioCiclo->exists)->method('save')),
        ];
    }

    public function save(ColegioCiclo $colegioCiclo, Request $request)
    {
        $request->validate([
            'colegio_ciclo.colegio_id' => 'required|exists:colegios,id',
            'colegio_ciclo.ciclo_id' => 'required|exists:ciclos,id',
        ]);
        $colegioCiclo->fill($request->get('colegio_ciclo'))->save();
        Toast::info(__('Colegio-Ciclo guardado correctamente'));
        return redirect()->route('platform.systems.colegio-ciclos');
    }

    public function remove(ColegioCiclo $colegioCiclo)
    {
        $colegioCiclo->delete();
        Toast::info(__('Colegio-Ciclo eliminado correctamente'));
        return redirect()->route('platform.systems.colegio-ciclos');
    }
}

