<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Docente;

use App\Models\Docente;
use App\Orchid\Layouts\Docente\DocenteListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class DocenteListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'docentes' => Docente::with('user', 'asignaturas')->defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Docentes';
    }

    public function description(): ?string
    {
        return 'Lista completa de todos los docentes registrados en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.docentes.create'),
        ];
    }

    public function layout(): iterable
    {
        return [DocenteListLayout::class];
    }

    public function remove(Request $request): void
    {
        Docente::findOrFail($request->get('id'))->delete();
        Toast::info(__('Docente eliminado correctamente'));
    }
}

