<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Grupo;

use App\Models\Grupo;
use App\Orchid\Layouts\Grupo\GrupoAlumnosLayout;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;

class GrupoAlumnosScreen extends Screen
{
    public $grupo;

    public function query(Grupo $grupo): iterable
    {
        $this->grupo = $grupo;
        
        $grupo->load([
            'colegioCiclo.colegio', 
            'colegioCiclo.ciclo', 
            'turno',
            'alumnos.user'
        ]);
        
        return [
            'grupo' => $grupo,
            'alumnos' => $grupo->alumnos()->with('user')->defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Alumnos del Grupo: ' . ($this->grupo->nombre_grupo ?? '');
    }

    public function description(): ?string
    {
        if (!$this->grupo) {
            return 'Lista de alumnos del grupo.';
        }
        
        $colegio = $this->grupo->colegioCiclo && $this->grupo->colegioCiclo->colegio 
            ? $this->grupo->colegioCiclo->colegio->nombre 
            : '';
        $ciclo = $this->grupo->colegioCiclo && $this->grupo->colegioCiclo->ciclo 
            ? $this->grupo->colegioCiclo->ciclo->nombre 
            : '';
        $turno = $this->grupo->turno ? $this->grupo->turno->nombre : '';
        
        $info = array_filter([$colegio, $ciclo, $turno]);
        return !empty($info) ? implode(' - ', $info) : 'Lista de alumnos del grupo.';
    }

    public function permission(): ?iterable
    {
        return null;
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Volver a Grupos'))
                ->icon('bs.arrow-left')
                ->route('platform.systems.grupos'),
        ];
    }

    public function layout(): iterable
    {
        return [GrupoAlumnosLayout::class];
    }
}

