<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Padre;

use App\Models\Padre;
use App\Orchid\Layouts\Padre\PadreListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class PadreListScreen extends Screen
{
    public function query(): iterable
    {
        return ['padres' => Padre::with('user')->defaultSort('id', 'desc')->paginate()];
    }

    public function name(): ?string { return 'Gestión de Padres'; }
    public function description(): ?string { return 'Lista de padres registrados.'; }
    public function permission(): ?iterable { return null; }

    public function commandBar(): iterable
    {
        return [Link::make(__('Agregar'))->icon('bs.plus-circle')->route('platform.systems.padres.create')];
    }

    public function layout(): iterable { return [PadreListLayout::class]; }

    public function remove(Request $request): void
    {
        Padre::findOrFail($request->get('id'))->delete();
        Toast::info(__('Padre eliminado correctamente'));
    }
}

