<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Periodo;

use App\Models\Periodo;
use App\Orchid\Layouts\Periodo\PeriodoListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class PeriodoListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'periodos' => Periodo::defaultSort('fecha_inicio', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Períodos Académicos';
    }

    public function description(): ?string
    {
        return 'Lista de períodos académicos personalizados (ej: "Marzo - Abril", "1er Trimestre", etc.).';
    }

    public function permission(): ?iterable
    {
        return null;
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.periodos.create'),
        ];
    }

    public function layout(): iterable
    {
        return [PeriodoListLayout::class];
    }

    public function remove(Request $request): void
    {
        Periodo::findOrFail($request->get('id'))->delete();
        Toast::info(__('Período eliminado correctamente'));
    }
}

