<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Turno;

use App\Models\Turno;
use App\Orchid\Layouts\Turno\TurnoListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class TurnoListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'turnos' => Turno::defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Turnos';
    }

    public function description(): ?string
    {
        return 'Lista completa de todos los turnos registrados en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.turnos.create'),
        ];
    }

    public function layout(): iterable
    {
        return [TurnoListLayout::class];
    }

    public function remove(Request $request): void
    {
        Turno::findOrFail($request->get('id'))->delete();
        Toast::info(__('Turno eliminado correctamente'));
    }
}

