<?php

use App\Models\Rol;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('roles', function (Blueprint $table): void {
            $table->increments('id');
            $table->string('slug')->unique();
            $table->string('name');
            $table->jsonb('permissions')->nullable();
            $table->timestamps();
        });

        // Crear roles por defecto
        $roles = [
            [
                'name' => 'Administrador',
                'slug' => 'administrador',
            ],
            [
                'name' => 'Docente',
                'slug' => 'docente',
            ],
            [
                'name' => 'Adscripto',
                'slug' => 'adscripto',
            ],
            [
                'name' => 'Alumno',
                'slug' => 'alumno',
            ],
            [
                'name' => 'Padre',
                'slug' => 'padre',
            ],
        ];

        foreach ($roles as $roleData) {
            Rol::firstOrCreate(
                ['slug' => $roleData['slug']],
                [
                    'name' => $roleData['name'],
                    'permissions' => null,
                ]
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('roles');
    }
};
