<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('apellido')->nullable()->after('name');
            $table->string('direccion')->nullable()->after('telefono');
            $table->string('celular', 50)->nullable()->after('direccion');
            $table->date('fecha_nacimiento')->nullable()->after('celular');
            $table->string('numero_documento', 50)->nullable()->after('fecha_nacimiento');
            $table->boolean('activo')->default(true)->after('numero_documento');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['apellido', 'direccion', 'celular', 'fecha_nacimiento', 'numero_documento', 'activo']);
        });
    }
};
