<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Eliminar todas las foreign keys primero
            $table->dropForeign(['docente_id']);
            $table->dropForeign(['asignatura_id']);
            $table->dropForeign(['grupo_id']);
        });
        
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Eliminar la clave primaria actual
            $table->dropPrimary(['docente_id', 'asignatura_id', 'grupo_id']);
            
            // Agregar un campo id auto-incremental como nueva clave primaria
            $table->id()->first();
            
            // Modificar grupo_id para que sea nullable
            $table->foreignId('grupo_id')->nullable()->change();
        });
        
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Recrear todas las foreign keys
            $table->foreign('docente_id')
                ->references('id')
                ->on('docentes')
                ->onDelete('cascade');
            
            $table->foreign('asignatura_id')
                ->references('id')
                ->on('asignaturas')
                ->onDelete('cascade');
            
            $table->foreign('grupo_id')
                ->references('id')
                ->on('grupos')
                ->onDelete('cascade');
            
            // Crear índices únicos para evitar duplicados
            // Índice único para cuando grupo_id NO es NULL (permite múltiples grupos)
            $table->unique(['docente_id', 'asignatura_id', 'grupo_id'], 'docente_asignatura_grupo_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Eliminar el índice único adicional
            $table->dropUnique('docente_asignatura_grupo_unique');
            
            // Eliminar todas las foreign keys
            $table->dropForeign(['docente_id']);
            $table->dropForeign(['asignatura_id']);
            $table->dropForeign(['grupo_id']);
        });
        
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Eliminar el campo id
            $table->dropColumn('id');
            
            // Modificar grupo_id para que no sea nullable
            $table->foreignId('grupo_id')->nullable(false)->change();
            
            // Recrear la clave primaria original
            $table->primary(['docente_id', 'asignatura_id', 'grupo_id']);
        });
        
        Schema::table('docente_asignatura_grupos', function (Blueprint $table) {
            // Recrear todas las foreign keys
            $table->foreign('docente_id')
                ->references('id')
                ->on('docentes')
                ->onDelete('cascade');
            
            $table->foreign('asignatura_id')
                ->references('id')
                ->on('asignaturas')
                ->onDelete('cascade');
            
            $table->foreign('grupo_id')
                ->references('id')
                ->on('grupos')
                ->onDelete('cascade');
        });
    }
};
