<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Obtener los nombres de las claves foráneas
        $foreignKeys = DB::select("
            SELECT CONSTRAINT_NAME 
            FROM information_schema.KEY_COLUMN_USAGE 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = 'calificacion_mensual' 
            AND REFERENCED_TABLE_NAME IS NOT NULL
        ");
        
        // Eliminar las claves foráneas
        foreach ($foreignKeys as $foreignKey) {
            $constraintName = $foreignKey->CONSTRAINT_NAME;
            DB::statement("ALTER TABLE calificacion_mensual DROP FOREIGN KEY `{$constraintName}`");
        }
        
        // Eliminar la clave primaria actual
        DB::statement('ALTER TABLE calificacion_mensual DROP PRIMARY KEY');
        
        // Crear nueva clave primaria que incluya numero
        DB::statement('ALTER TABLE calificacion_mensual ADD PRIMARY KEY (alumno_id, asignatura_id, docente_id, mes, anio, numero)');
        
        // Restaurar las claves foráneas
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_alumno_id_foreign FOREIGN KEY (alumno_id) REFERENCES alumnos(id) ON DELETE CASCADE');
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_asignatura_id_foreign FOREIGN KEY (asignatura_id) REFERENCES asignaturas(id) ON DELETE CASCADE');
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_docente_id_foreign FOREIGN KEY (docente_id) REFERENCES docentes(id) ON DELETE CASCADE');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Obtener los nombres de las claves foráneas
        $foreignKeys = DB::select("
            SELECT CONSTRAINT_NAME 
            FROM information_schema.KEY_COLUMN_USAGE 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = 'calificacion_mensual' 
            AND REFERENCED_TABLE_NAME IS NOT NULL
        ");
        
        // Eliminar las claves foráneas
        foreach ($foreignKeys as $foreignKey) {
            $constraintName = $foreignKey->CONSTRAINT_NAME;
            DB::statement("ALTER TABLE calificacion_mensual DROP FOREIGN KEY `{$constraintName}`");
        }
        
        // Eliminar la clave primaria actual (con numero)
        DB::statement('ALTER TABLE calificacion_mensual DROP PRIMARY KEY');
        
        // Restaurar la clave primaria original (sin numero)
        DB::statement('ALTER TABLE calificacion_mensual ADD PRIMARY KEY (alumno_id, asignatura_id, docente_id, mes, anio)');
        
        // Restaurar las claves foráneas
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_alumno_id_foreign FOREIGN KEY (alumno_id) REFERENCES alumnos(id) ON DELETE CASCADE');
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_asignatura_id_foreign FOREIGN KEY (asignatura_id) REFERENCES asignaturas(id) ON DELETE CASCADE');
        DB::statement('ALTER TABLE calificacion_mensual ADD CONSTRAINT calificacion_mensual_docente_id_foreign FOREIGN KEY (docente_id) REFERENCES docentes(id) ON DELETE CASCADE');
    }
};
