<?php

namespace Database\Seeders;

use App\Models\Rol;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'Administrador',
                'slug' => 'administrador',
            ],
            [
                'name' => 'Docente',
                'slug' => 'docente',
            ],
            [
                'name' => 'Adscripto',
                'slug' => 'adscripto',
            ],
            [
                'name' => 'Alumno',
                'slug' => 'alumno',
            ],
            [
                'name' => 'Padre',
                'slug' => 'padre',
            ],
        ];

        foreach ($roles as $roleData) {
            Rol::firstOrCreate(
                ['slug' => $roleData['slug']],
                [
                    'name' => $roleData['name'],
                    'permissions' => null,
                ]
            );
        }
    }
}

