# MIGRACIONES EN LARAVEL

## Crear una nueva migración

```bash
php artisan make:migration nombre_de_la_migracion
```
Crea un nuevo archivo de migración en `database/migrations`.

## Modificar la migración
Edita el archivo generado y agrega tus cambios en los métodos:
- `up()`: Cambios a aplicar.
- `down()`: Cambios para revertir (rollback).

**Ejemplo para agregar y quitar una columna `telefono` en la tabla `users`:**

```php
public function up()
{
    Schema::table('users', function (Blueprint $table) {
        $table->string('telefono')->nullable();
    });
}

public function down()
{
    Schema::table('users', function (Blueprint $table) {
        $table->dropColumn('telefono');
    });
}
```

## Ejecutar migraciones pendientes

```bash
php artisan migrate
```
Aplica todas las migraciones no ejecutadas.

## Hacer rollback de la última migración

```bash
php artisan migrate:rollback
```
Revierte el último batch de migraciones ejecutadas.

## Hacer rollback de X migraciones

```bash
php artisan migrate:rollback --step=NUMERO
```
Reemplaza `NUMERO` por la cantidad de migraciones que quieres revertir.
