<script>
document.addEventListener('DOMContentLoaded', function() {
    const nameInput = document.getElementById('role-name-input');
    const slugInput = document.getElementById('role-slug-input');
    
    if (nameInput && slugInput) {
        let isUserTypingSlug = false;
        
        // Detectar si el usuario está editando manualmente el slug
        slugInput.addEventListener('focus', function() {
            isUserTypingSlug = true;
            slugInput.readOnly = false;
        });
        
        slugInput.addEventListener('blur', function() {
            if (!slugInput.value.trim()) {
                isUserTypingSlug = false;
                slugInput.readOnly = true;
                generateSlug();
            }
        });
        
        // Función para generar slug
        function generateSlug() {
            if (!isUserTypingSlug || !slugInput.value.trim()) {
                const name = nameInput.value;
                const slug = name
                    .toLowerCase()
                    .normalize('NFD')
                    .replace(/[\u0300-\u036f]/g, '') // Eliminar acentos
                    .replace(/[^a-z0-9]+/g, '-') // Reemplazar caracteres especiales con guiones
                    .replace(/^-+|-+$/g, ''); // Eliminar guiones al inicio y final
                
                slugInput.value = slug;
            }
        }
        
        // Generar slug cuando se escribe en el campo name
        nameInput.addEventListener('input', function() {
            if (!isUserTypingSlug || !slugInput.value.trim()) {
                generateSlug();
            }
        });
        
        // Generar slug inicial si el campo name tiene valor pero slug está vacío
        if (nameInput.value && !slugInput.value) {
            generateSlug();
        }
    }
});
</script>

