<?php

declare(strict_types=1);

use App\Orchid\Screens\Alumno\AlumnoEditScreen;
use App\Orchid\Screens\Alumno\AlumnoListScreen;
use App\Orchid\Screens\Alumno\AlumnoShowScreen;
use App\Orchid\Screens\Asignatura\AsignaturaEditScreen;
use App\Orchid\Screens\Asignatura\AsignaturaListScreen;
use App\Orchid\Screens\Calificacion\CalificacionAlumnoScreen;
use App\Orchid\Screens\Calificacion\CalificacionEditScreen;
use App\Orchid\Screens\Calificacion\CalificacionListScreen;
use App\Orchid\Screens\CalificacionPeriodo\CalificacionPeriodoEditScreen;
use App\Orchid\Screens\CalificacionPeriodo\CalificacionPeriodoListScreen;
use App\Orchid\Screens\Periodo\PeriodoEditScreen;
use App\Orchid\Screens\Periodo\PeriodoListScreen;
use App\Orchid\Screens\Ciclo\CicloEditScreen;
use App\Orchid\Screens\Ciclo\CicloListScreen;
use App\Orchid\Screens\Colegio\ColegioEditScreen;
use App\Orchid\Screens\Colegio\ColegioListScreen;
use App\Orchid\Screens\Docente\DocenteEditScreen;
use App\Orchid\Screens\Docente\DocenteListScreen;
use App\Orchid\Screens\Examples\ExampleActionsScreen;
use App\Orchid\Screens\Examples\ExampleCardsScreen;
use App\Orchid\Screens\Examples\ExampleChartsScreen;
use App\Orchid\Screens\Examples\ExampleFieldsAdvancedScreen;
use App\Orchid\Screens\Examples\ExampleFieldsScreen;
use App\Orchid\Screens\Examples\ExampleGridScreen;
use App\Orchid\Screens\Examples\ExampleLayoutsScreen;
use App\Orchid\Screens\Examples\ExampleScreen;
use App\Orchid\Screens\Examples\ExampleTextEditorsScreen;
use App\Orchid\Screens\Grupo\GrupoAlumnosScreen;
use App\Orchid\Screens\Grupo\GrupoEditScreen;
use App\Orchid\Screens\Grupo\GrupoListScreen;
use App\Orchid\Screens\Padre\PadreEditScreen;
use App\Orchid\Screens\Padre\PadreListScreen;
use App\Orchid\Screens\PlatformScreen;
use App\Orchid\Screens\Role\RoleEditScreen;
use App\Orchid\Screens\Role\RoleListScreen;
use App\Orchid\Screens\Turno\TurnoEditScreen;
use App\Orchid\Screens\Turno\TurnoListScreen;
use App\Orchid\Screens\User\UserEditScreen;
use App\Orchid\Screens\User\UserListScreen;
use App\Orchid\Screens\User\UserProfileScreen;
use App\Orchid\Screens\Adscripto\AdscriptoEditScreen;
use App\Orchid\Screens\Adscripto\AdscriptoListScreen;
use Illuminate\Support\Facades\Route;
use Tabuna\Breadcrumbs\Trail;

/*
|--------------------------------------------------------------------------
| Dashboard Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the need "dashboard" middleware group. Now create something great!
|
*/

// Main
Route::screen('/main', PlatformScreen::class)
    ->name('platform.main');

// Platform > Profile
Route::screen('profile', UserProfileScreen::class)
    ->name('platform.profile')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.index')
        ->push(__('Profile'), route('platform.profile')));

// Platform > System > Users > User
Route::screen('users/{user}/edit', UserEditScreen::class)
    ->name('platform.systems.users.edit')
    ->breadcrumbs(fn (Trail $trail, $user) => $trail
        ->parent('platform.systems.users')
        ->push($user->name, route('platform.systems.users.edit', $user)));

// Platform > System > Users > Create
Route::screen('users/create', UserEditScreen::class)
    ->name('platform.systems.users.create')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.systems.users')
        ->push(__('Create'), route('platform.systems.users.create')));

// Platform > System > Users
Route::screen('users', UserListScreen::class)
    ->name('platform.systems.users')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.index')
        ->push(__('Users'), route('platform.systems.users')));

// Platform > System > Roles > Role
Route::screen('roles/{role}/edit', RoleEditScreen::class)
    ->name('platform.systems.roles.edit')
    ->breadcrumbs(fn (Trail $trail, $role) => $trail
        ->parent('platform.systems.roles')
        ->push($role->name, route('platform.systems.roles.edit', $role)));

// Platform > System > Roles > Create
Route::screen('roles/create', RoleEditScreen::class)
    ->name('platform.systems.roles.create')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.systems.roles')
        ->push(__('Create'), route('platform.systems.roles.create')));

// Platform > System > Roles
Route::screen('roles', RoleListScreen::class)
    ->name('platform.systems.roles')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.index')
        ->push(__('Roles'), route('platform.systems.roles')));

// Colegios
Route::screen('colegios', ColegioListScreen::class)->name('platform.systems.colegios');
Route::screen('colegios/create', ColegioEditScreen::class)->name('platform.systems.colegios.create');
Route::screen('colegios/{colegio}/edit', ColegioEditScreen::class)->name('platform.systems.colegios.edit');

// Ciclos
Route::screen('ciclos', CicloListScreen::class)->name('platform.systems.ciclos');
Route::screen('ciclos/create', CicloEditScreen::class)->name('platform.systems.ciclos.create');
Route::screen('ciclos/{ciclo}/edit', CicloEditScreen::class)->name('platform.systems.ciclos.edit');

// Turnos
Route::screen('turnos', TurnoListScreen::class)->name('platform.systems.turnos');
Route::screen('turnos/create', TurnoEditScreen::class)->name('platform.systems.turnos.create');
Route::screen('turnos/{turno}/edit', TurnoEditScreen::class)->name('platform.systems.turnos.edit');

// Asignaturas
Route::screen('asignaturas', AsignaturaListScreen::class)->name('platform.systems.asignaturas');
Route::screen('asignaturas/create', AsignaturaEditScreen::class)->name('platform.systems.asignaturas.create');
Route::screen('asignaturas/{asignatura}/edit', AsignaturaEditScreen::class)->name('platform.systems.asignaturas.edit');

// Grupos
Route::screen('grupos', GrupoListScreen::class)->name('platform.systems.grupos');
Route::screen('grupos/create', GrupoEditScreen::class)->name('platform.systems.grupos.create');
Route::screen('grupos/{grupo}/edit', GrupoEditScreen::class)->name('platform.systems.grupos.edit');
Route::screen('grupos/{grupo}/alumnos', GrupoAlumnosScreen::class)->name('platform.systems.grupos.alumnos');

// Docentes
Route::screen('docentes', DocenteListScreen::class)->name('platform.systems.docentes');
Route::screen('docentes/create', DocenteEditScreen::class)->name('platform.systems.docentes.create');
Route::screen('docentes/{docente}/edit', DocenteEditScreen::class)->name('platform.systems.docentes.edit');

// Alumnos
Route::screen('alumnos', AlumnoListScreen::class)->name('platform.systems.alumnos');
Route::screen('alumnos/create', AlumnoEditScreen::class)->name('platform.systems.alumnos.create');
Route::screen('alumnos/{alumno}/edit', AlumnoEditScreen::class)->name('platform.systems.alumnos.edit');
Route::screen('alumnos/{alumno}', AlumnoShowScreen::class)->name('platform.systems.alumnos.show');
Route::screen('alumnos/{alumno}/calificaciones/ver', \App\Orchid\Screens\Calificacion\VerCalificacionesAlumnoScreen::class)->name('platform.systems.alumnos.ver_calificaciones');

// Adscriptos
Route::screen('adscriptos', AdscriptoListScreen::class)->name('platform.systems.adscriptos');
Route::screen('adscriptos/create', AdscriptoEditScreen::class)->name('platform.systems.adscriptos.create');
Route::screen('adscriptos/{adscripto}/edit', AdscriptoEditScreen::class)->name('platform.systems.adscriptos.edit');

// Padres
Route::screen('padres', PadreListScreen::class)->name('platform.systems.padres');
Route::screen('padres/create', PadreEditScreen::class)->name('platform.systems.padres.create');
Route::screen('padres/{padre}/edit', PadreEditScreen::class)->name('platform.systems.padres.edit');

// Períodos Académicos
Route::screen('periodos', PeriodoListScreen::class)->name('platform.systems.periodos');
Route::screen('periodos/create', PeriodoEditScreen::class)->name('platform.systems.periodos.create');
Route::screen('periodos/{periodo}/edit', PeriodoEditScreen::class)->name('platform.systems.periodos.edit');

// Calificaciones
Route::screen('calificaciones', CalificacionListScreen::class)->name('platform.systems.calificaciones');
Route::screen('calificaciones/create', CalificacionEditScreen::class)->name('platform.systems.calificaciones.create');
Route::screen('calificaciones/edit', CalificacionEditScreen::class)->name('platform.systems.calificaciones.edit');

// Calificaciones por Alumno
Route::screen('alumnos/{alumno}/calificaciones', CalificacionAlumnoScreen::class)->name('platform.systems.alumnos.calificaciones');

// Calificaciones por Período
Route::screen('calificaciones-periodo', CalificacionPeriodoListScreen::class)->name('platform.systems.calificaciones-periodo');
Route::screen('calificaciones-periodo/create', CalificacionPeriodoEditScreen::class)->name('platform.systems.calificaciones-periodo.create');
Route::screen('calificaciones-periodo/edit', CalificacionPeriodoEditScreen::class)->name('platform.systems.calificaciones-periodo.edit');

// Example...
Route::screen('example', ExampleScreen::class)
    ->name('platform.example')
    ->breadcrumbs(fn (Trail $trail) => $trail
        ->parent('platform.index')
        ->push('Example Screen'));

Route::screen('/examples/form/fields', ExampleFieldsScreen::class)->name('platform.example.fields');
Route::screen('/examples/form/advanced', ExampleFieldsAdvancedScreen::class)->name('platform.example.advanced');
Route::screen('/examples/form/editors', ExampleTextEditorsScreen::class)->name('platform.example.editors');
Route::screen('/examples/form/actions', ExampleActionsScreen::class)->name('platform.example.actions');

Route::screen('/examples/layouts', ExampleLayoutsScreen::class)->name('platform.example.layouts');
Route::screen('/examples/grid', ExampleGridScreen::class)->name('platform.example.grid');
Route::screen('/examples/charts', ExampleChartsScreen::class)->name('platform.example.charts');
Route::screen('/examples/cards', ExampleCardsScreen::class)->name('platform.example.cards');

// Route::screen('idea', Idea::class, 'platform.screens.idea');
